globals [
  max-age               ;; maximln vk, kterho se sedmikrsky doij
  global-temperature    ;; prmrn teplota ze vech polek v modelu
  num-blacks            ;; poet ernch sedmikrsek
  num-whites            ;; poet blch sedmikrsek
  scenar-phase          ;; intervalov potadlo, umoujc urit, jak je fze aktulnho scne slunenho zen
  ]

breed [daisies daisy]

patches-own [temperature]  ;; lokln teplota na danm polku
daisies-own [
  age       ;; vk sedmikrsky
  albedo    ;; st (0-1) energie absorbovan ve form tepla ze slunce
]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Procedury tlatka Piprav ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set-default-shape daisies "flower"
  ask patches [ set pcolor gray ]

  set max-age 25
  set global-temperature 0

  if (scenar = "nahoru-dol"    ) [ set slunecni-zareni 0.85 ]
  if (scenar = "nzk slunen zen" ) [ set slunecni-zareni 0.6 ]
  if (scenar = "stedn slunen zen" ) [ set slunecni-zareni 1.0 ]
  if (scenar = "vysok slunen zen") [ set slunecni-zareni 1.4 ]

  seed-blacks-randomly
  seed-whites-randomly
  ask daisies [set age random max-age]
  ask patches [calc-temperature]
  set global-temperature (mean [temperature] of patches)
  update-display
  update-plots
end

to seed-blacks-randomly
   ask n-of round ((start-%-cernych * count patches) / 100) patches with [not any? daisies-here]
     [ sprout-daisies 1 [set-as-black] ]
end

to seed-whites-randomly
   ask n-of floor ((start-%-bilych * count patches) / 100) patches with [not any? daisies-here]
     [ sprout-daisies 1 [set-as-white] ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Procedury tlatka Start ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to go
   ask patches [calc-temperature]
   diffuse temperature .5
   ask daisies [check-survivability]
   set global-temperature (mean [temperature] of patches)
   update-display
   tick
   update-plots
   if (scenar = "nahoru-dol")
   [
     if (ticks > 200 and ticks <= 400) [set slunecni-zareni slunecni-zareni + 0.005]
     if (ticks > 600 and ticks <= 800) [set slunecni-zareni slunecni-zareni - 0.005]
   ]
   if (scenar = "nzk slunen zen")  [set slunecni-zareni 0.6 ]
   if (scenar = "stedn slunen zen")  [set slunecni-zareni 1.0 ]
   if (scenar = "vysok slunen zen") [set slunecni-zareni 1.4 ]
end

to set-as-black ;; procedura elv
  set color black
  set albedo albedo-cernych
  set age 0
  set size 0.6
end

to set-as-white  ;; procedura elv
  set color white
  set albedo albedo-bilych
  set age 0
  set size 0.6
end

to check-survivability ;; procedura elv
  let seed-threshold 0
  let not-empty-spaces nobody
  let seeding-place nobody

  set age (age + 1)
  ifelse age < max-age
  [
     set seed-threshold ((0.1457 * temperature) - (0.0032 * (temperature ^ 2)) - (0.6443))
     ;; Tato rovnice me psobi sloit, ale jedn se pouze o vyjden paraboly.
     ;; Tato parabola m vrchol v bod 1, co se rovn maximlnmu faktoru rstu
     ;; pi optimln teplot 22.5 stupn Celsia a naopak kles na 
     ;; hodnotu 0 v mstech pekroen teploty pod 5 a nad 40 stup (hranin body paraboly na ose x).
     ;; Dky tomu se nov sedmikrsky mohou vyskytovat jen v tomto teplotnm intervalu --
     ;; pravdpodobnost rstu nov sedmikrsky kles smrm k tmto krajnm bodm paraboly. 
     ;; Zapamatujte si, e pravdpodobnostn vpoet je zaloen na lokln teplot.

     if (random-float 1.0 < seed-threshold) [
       set seeding-place one-of neighbors with [not any? daisies-here]

       if (seeding-place != nobody)
       [
         if (color = white)
         [
           ask seeding-place [sprout-daisies 1 [set-as-white]  ]
         ]
         if (color = black)
         [
           ask seeding-place [sprout-daisies 1 [set-as-black]  ]
         ]
       ]
     ]
  ]
  [die]
end

to calc-temperature  ;; procedura polek
  let absorbed-luminosity 0
  let local-heating 0
  ifelse not any? daisies-here
  [   ;; procento absorbovan energie se vypote jako (1 - albedo-povrchu) a nsledn se nsob
      ;; hodnotou slunecni-zareni, abychom zskali klovanou hodnotu promnn absorbed-luminosity
    set absorbed-luminosity ((1 - albedo-povrchu) * slunecni-zareni)
  ]
  [
      ;; procento absorbovan energie se vypote jako (1 - albedo) a nsledn se nsob
      ;; hodnotou slunecni-zareni, abychom zskali klovanou hodnotu promnn absorbed-luminosity
    ask one-of daisies-here
      [set absorbed-luminosity ((1 - albedo) * slunecni-zareni)]
  ]
  ;; local-heating (lokln vyhvn) je vypoteno jako logaritmick funkce hodnoty slunecni-zareni,
  ;; kde absorbed-luminosity 1 znamen local-heating rovn 80 stup C
  ;; a absorbed-luminosity 0.5 znamen local-heating rovn zhruba 30 stup C
  ;; a absorbed-luminosity 0.01 znamen local-heating rovn zhruba -273 stup C.
  set local-heating 72 * LN(absorbed-luminosity) + 80
  set temperature ((temperature + local-heating) / 2)
     ;; nastav teplotu tak, aby se stala prmrem mezi stvajc teplotou a hodnotou local-heating
end

to paint-daisies   ;; procedura pro run kreslen sedmikrsek my do grafiky pomoc stisknutho tlatka
  if mouse-down?
  [
    ask patch mouse-xcor mouse-ycor [
      ifelse not any? daisies-here
      [
        if kresli-sedmikrasky-jako = "pidej ernou"
          [sprout-daisies 1 [set-as-black]]
        if kresli-sedmikrasky-jako = "pidej blou"
          [sprout-daisies 1 [set-as-white]]
      ]
      [
        if kresli-sedmikrasky-jako = "odstra"
          [ask daisies-here [die]]
      ]
      display  ;; aktualizuj zobrazen
    ]
  ]
end

to update-display
  ifelse (ukazat-teplotni-mapu? = true)
    [ ask patches [set pcolor scale-color red temperature -50 110] ]  ;; barevn pechod polek pro vyjden mstn teploty 
    [ ask patches [set pcolor grey] ]

  ifelse (ukazat-sedmikrasky? = true)
    [ ask daisies [set hidden? false] ]
    [ ask daisies [set hidden? true] ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Procedury grafu  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to update-plots
  set-current-plot "Globln teplota"
  plot global-temperature

  set-current-plot "Slunen zen"
  plot slunecni-zareni

  set num-whites count turtles with [color = white]
  set num-blacks count turtles with [color = black]

  set-current-plot "Populace"
  set-current-plot-pen "Black"
  plot num-blacks
  set-current-plot-pen "White"
  plot num-whites
end


; *** NetLogo 4.0.2 Model Copyright Notice ***
;
; Copyright 2006 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Novak, M. and Wilensky, U. (2006). NetLogo Daisyworld model.
; http://ccl.northwestern.edu/netlogo/models/Daisyworld.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2006 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Daisyworld
; for terms of use.
;
; *** End of NetLogo 4.0.2 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
424
10
869
476
14
14
15.0
1
10
1
1
1
0
1
1
1
-14
14
-14
14
1
1
1
ticks

CC-WINDOW
5
569
878
664
Command Center
0

SLIDER
5
180
200
213
albedo-povrchu
albedo-povrchu
0
0.99
0.42
0.01
1
NIL
HORIZONTAL

CHOOSER
5
90
202
135
scenar
scenar
"nahoru-dol" "nastaviteln slunen zen" "nzk slunen zen" "stedn slunen zen" "vysok slunen zen"
1

SLIDER
5
140
200
173
slunecni-zareni
slunecni-zareni
0.0010
3
1
0.0010
1
NIL
HORIZONTAL

SLIDER
245
10
415
43
start-%-cernych
start-%-cernych
0
50
20
1
1
NIL
HORIZONTAL

SLIDER
75
10
240
43
start-%-bilych
start-%-bilych
0
50
20
1
1
NIL
HORIZONTAL

SWITCH
7
302
176
335
ukazat-teplotni-mapu?
ukazat-teplotni-mapu?
0
1
-1000

BUTTON
3
45
68
78
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
3
10
74
43
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
7
260
177
293
ukazat-sedmikrasky?
ukazat-sedmikrasky?
0
1
-1000

PLOT
215
85
415
235
Slunen zen
NIL
NIL
0.0
100.0
0.5
1.5
true
false
PENS
"default" 1.0 0 -16777216 true

PLOT
215
245
415
395
Globln teplota
NIL
NIL
0.0
100.0
-20.0
50.0
true
false
PENS
"default" 1.0 0 -16777216 true

PLOT
215
405
415
555
Populace
NIL
NIL
0.0
100.0
0.0
100.0
true
false
PENS
"black" 1.0 0 -16777216 true
"white" 1.0 0 -7500403 true

SLIDER
75
45
240
78
albedo-bilych
albedo-bilych
0
0.99
0.75
0.01
1
NIL
HORIZONTAL

SLIDER
245
45
415
78
albedo-cernych
albedo-cernych
0
0.99
0.25
0.01
1
NIL
HORIZONTAL

BUTTON
8
449
204
494
Odstra vechny sedmikrsky
ask daisies [die]\ndisplay
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
7
398
204
441
Kresli sedmikrsky
paint-daisies
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

CHOOSER
7
345
176
390
kresli-sedmikrasky-jako
kresli-sedmikrasky-jako
"pidej ernou" "pidej blou" "odstra"
0

@#$#@#$#@
CO TO JE?
---------
Tento model zkoum tzv. "hypotzu Gaia", kter chpe Zemi jako jedin sebe-regulujc systm zahrnujc iv i neiv sti. Konkrtn tento model zkoum, jak iv organismy ovlivuj neiv klima a zrove jak jsou organismy samy klimatem ovlivovny. Organismy, kter nm zde slou jako pklad, jsou sedmikrsky. Klimatickm faktorem je teplota. 

Svt sedmikrsek je naplnn dvma typy sedmikrsek: ernmi a blmi. Li se v albedu, co je schopnost odret energii ze slunenho zen. Bl sedmikrsky maj vysok albedo, proto odrej teplo a ochlazuj tak oblast kolem sebe. ern sedmikrsky maj nzk albedo, proto absorbuj teplo a naopka sv okol ohvaj. Sedmikrsky se vak mohou rozmnoovat pouze v jistm teplotnm rozpt. Pokud teplota okolo sedmikrsky bude mimo toto rozpt, sedmikrska nebude mt potomky a po ase zeme stm. 

Kdy je klima pli chladn, je nutn, aby se rozmnoily ern sedmikrsky a zvily teplotu. A obrcen - kdy je klima pli hork, mly by se rozmnoit bl sedmikrsky, aby se ochladilo. Pi irokm rozmez nastaven parametr se teplota i populace sedmikrsek stabilizuje. Avak ve svt sedmikrsek nen vyloueno, e teplota bude tak nzk, i naopak tak vysok, e ji sedmikrsky nebudou schopny dostat pod kontrolu a vechny sedmikrsky nakonec zahynou.

JAK TO FUNGUJE?
---------------
Bl sedmikrsky, ern sedmikrsky a przdn polka maj dan albedo, tedy procento tepeln energie, kter absorbuj ze slunenho zen. Mnostv slunenho zen se mn nastavenm SLUNEN-ZEN (hodnota 1.0 simuluje prmrnou intenzitu zen naeho slunce). 

V kadm kole je pro vechna polka spotena, kter se skld za prv z energie absorbovan tmto polkem a za druh z 50 % rozptylu tepla ze sousednch polek. Na przdnm polku, kter soused s njakou sedmikrskou, me vyrst nov sedmikrska stejn barvy jako ta sousedn. Pravdpodobnost rstu je zvisl na teplot. Pi optimln teplot 22,5 stupn je pravdpodobnost rovn 100 %, pi teplotch nich ne 5 nebo vych ne 40 stup kles pravdpodobnost rstu na nulu (funkce popisujc pravdpodobnost rstu m tvar obrcen paraboly protnajc osu x v bodech 5 a 40). V kadm kole sedmikrsky strnou, dokud nedoshnou maximlnho vku, potom hynou a polko, na kterm rostly, zstane przdn. 

JAK MODEL OVLDAT
-----------------
START-%-BILYCH a START-%-CERNYCH nastav poten procenta polek, na kterch porostou sedmikrsky obou barev. Je nutn stisknout tlatko PIPRAV. 

ALBEDO-BILYCH a ALBEDO-CERNYCH nastav mnostv tepla absorbovan obma druhy sedmikrsek. ALBEDO-POVRCHU nastav mnostv tepla absorbovan przdnm polkem. 

SLUNECNI-ZARENI nastav mnostv slunen energie dopadajc na kad polko. Tato hodnota vak zstane stabiln pouze pokud uivatel zvol scn "zachovej souasn zen". Jin scne budou tuto hodnotu postupn mnit. Napklad scn "nahoru-dol" zane s nzkm zenm, kter bude postupn zvyovat na vysokou hodnotu, a pot ho zase sn, co se bude opakovat po celou dobu bhu modelu.

UKAZAT-TEPLOTNI-MAPU? uke barevnou mapu teplot vech polek. Svtle erven pedstavuje vy teploty a tmav erven pedstavuje ni teploty.

Vybrnm KRESLI-SEMIKRSKY-JAKO a stisknutm  KRESLI-SEDMIKRSKY povol uivatel run kreslen sedmikrsek v grafickm okn. Sta na voln polko kliknout levm tlatkem myi. 

VIMNTE SI
-----------
Puste model. Co se dje se sedmikrskami? Zstvaj populace stabiln? Objevuj se prudk prstky i bytky populace? Pokud ano, co je zpsobuje? (Npovda: Jak ovlivuj sedmikrsky klima? Jak potom klima ovlivuje sedmikrsky?) 

Vede nutn prstek slunenho zen ke zven globln teploty? 

Me nastat situace, kdy se objev cykly prstk a bytk populace, kter se stle zvtuj? Co se nakonec stane? 

Me jeden z druh sedmikrsek zcela zmizet? Jak se zmn sebe-regulan schopnosti planety, kdy na n zstane jen jeden druh? 

Me bt svt sedmikrsek nkdy zcela zaplnn ivotem, nebo naopak zcela bez ivota?

Me svt sedmikrsek vykazovat "hysterezi"? Hystereze je vlastnost systmu, kter nereaguje na psobc sly okamit, ale reaguje se zpodnm nebo se nevrac do stavu zcela totonho se stavem pvodnm. Stav takovho systmu zvis na jeho bezprostedn historii. 

ZKUSTE SI
---------
Zkuste pustit model s vypnutou volbou UKAZAT-SEDMIKRASKY? a zapnutou volbou UKAZAT-TEPLOTNI-MAPU?. Snadnji budete moci pozorovat zajmav prostorov vzory vznikajc v teplotnch koncentracch a jejich opakujc se pesuny. 

Pokud zcela zmiz jeden druh sedmikrsek, zkuste ho znovu run vloit do modelu (stisknte KRESLI-SEDMIKRSKY a vyberte druh sedmikrsek, pot kliknte my na voln polko). Pro kter teploty se druh znovu roz? 

Zkuste pustit model zcela bez ivota. Co se stane s globln teplotou? Jak se li od teploty, kter nastane, pokud nechme sedmikrsky rst?  
Zkuste podobn jako u pedchozho pkladu vloit sedmikrsky znovu run do modelu. 

Zkuste zmnit pevn nastaven rozptylu (diffusion) v kdu programu. Je nastaveno na 0,5. Co se stane, kdy ho nastavte na 0, a teplota se dky tomu pestane rozptylovat?  

ROZEN MODELU
----------------
Bl a ern sedmikrsky pedstavuj dva extrmn typy sedmikrsek, kter mohou v tomto svt existovat. Doplte do modelu tet druh sedmikrsek. Muste urit jak se bude vae sedmikrska chovat a v em se bude liit od blch a ernch. Jak ovlivuje vae nov sedmikrska chovn modelu?

Slunen zen je jen jednou slokou, kter kontroluje rst sedmikrsek nebo jinch forem ivota. Zmte model tak, aby rzn sti svta mly rznou kvalitu pdy. Jak dsledky to bude mt pro chovn modelu? 

Mnoho lid se domnv, e sebe-regulaci, kterou popisuje hypotza Gaia, me naruit lidsk innost, nap. zneitn. Doplte do modelu zneitn. Vede to k astjmu umrn sedmikrsek? 

Dokete najt jin zpsoby jak mohou iv organismy ovlivovat sv prosted a jsou naopak prostedm ovlivovny? 

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------
Model vyuv primitivum "diffuse" k distribuci tepla mezi polky. 

SOUVISEJC MODELY
------------------
Alternativn model Svta sedmikrsek vyuvajc pouze polka (patches) a nikoliv elvy (turtles) mete naj na strnkch model uivatelsk komunity (User Community Model). 
http://ccl.northwestern.edu/netlogo/models/community/

PODKOVN A ODKAZY
-------------------
Model Svta sedmikrsek (Daisyworld) byl poprv navren a implementovn Jamesem Lovelockem a Andrew Watsonem. Autorem pvodn hypotzy Gaia je James Lovelock.
Watson, A.J., and J.E. Lovelock, 1983, "Biological homeostasis of the global environment: the parable of Daisyworld", Tellus 35B, 286-289. (Pvodn lnek Watsona a Lovelocka popisujc model Svta sedmikrsek.)
http://www.carleton.edu/departments/geol/DaveSTELLA/Daisyworld/daisyworld_model.htm

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Novak, M. and Wilensky, U. (2006).  NetLogo Daisyworld model.  http://ccl.northwestern.edu/netlogo/models/Daisyworld.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace:  Copyright 1997 Uri Wilensky.  All rights reserved.  
Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/Daisyworld .

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
true
0
Circle -7500403 true true 30 30 240
Circle -7500403 true true 0 120 60
Circle -7500403 true true 240 120 60
Circle -7500403 true true 120 0 60
Circle -7500403 true true 120 240 60
Circle -7500403 true true 60 225 60
Circle -7500403 true true 180 225 60
Circle -7500403 true true 225 180 60
Circle -7500403 true true 15 180 60
Circle -7500403 true true 15 60 60
Circle -7500403 true true 225 60 60
Circle -7500403 true true 180 15 60
Circle -7500403 true true 60 15 60

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
